/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.pe.peorb.client.ClientInfoUtilities;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.server.Configuration;
import filenet.vw.server.VWBootstrapURL;
import filenet.vw.server.VWRMIRouterURL;
import filenet.vw.soap.server.IVWSOAPContext;
import filenet.vw.soap.server.IVWSOAPSessionManager;
import filenet.vw.soap.server.VWNoConnectionPointInSitePref;
import filenet.vw.soap.server.VWSOAPSessionInfo;
import filenet.vw.soap.util.VWSOAPUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.apache.soap.util.xml.XMLParserUtils;

public class VWRouterServlet
extends HttpServlet {
    private static final String PARAMNAME_SOAPCONFIGFILE = "SOAPConfigFile";
    private static final String PARAMVALUE_SOAPCONFIGFILE_DEFAULT = null;
    private static final String PARAMNAME_PROVIDERNAME = "VWServiceProvider";
    private static final String PARAMVALUE_PROVIDER_DEFAULT = "filenet.vw.soap.server.VWSOAPServiceProvider";
    private static final String PARAMNAME_CLASSNAME = "VWServiceClass";
    private static final String PARAMVALUE_CLASS_DEFAULT = "filenet.vw.soap.server.VWSOAPService";
    private static final String PARAMNAME_SCOPE = "VWServiceScope";
    private static final String PARAMVALUE_SCOPE_APPLICATION = "Application";
    private static final String PARAMVALUE_SCOPE_SESSION = "Session";
    private static final String PARAMNAME_METHODS = "VWServiceMethods";
    private EnvelopeEditor editor = null;
    private static Class VWServiceClass = null;
    private Hashtable m_CPsInfo = new Hashtable();
    private String m_CEURI = null;
    private String m_soapConfigFileName = null;
    private static Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static String m_className = "VWRouterServlet";
    private static String P8BPMWSBROKER_PROPERTIES_FILENAME = null;
    private String lastCp = null;
    private static final long serialVersionUID = 464L;

    private String[] parseStringList(String source) {
        if (source == null) {
            return null;
        }
        String m_method = "parseStringList:" + source;
        logger.entering(m_className, m_method);
        StringTokenizer st = new StringTokenizer(source, ", ");
        int nTokens = st.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    private DeploymentDescriptor getVWSOAPServiceDD() throws Exception {
        String serviceClassName;
        ServletConfig config = this.getServletConfig();
        String providerName = config.getInitParameter(PARAMNAME_PROVIDERNAME);
        if (providerName == null) {
            providerName = PARAMVALUE_PROVIDER_DEFAULT;
        }
        if ((serviceClassName = config.getInitParameter(PARAMNAME_CLASSNAME)) == null) {
            serviceClassName = PARAMVALUE_CLASS_DEFAULT;
        }
        int serviceScope = 0;
        String serviceScopeStr = config.getInitParameter(PARAMNAME_SCOPE);
        if (serviceScopeStr != null) {
            if (serviceScopeStr.equalsIgnoreCase(PARAMVALUE_SCOPE_APPLICATION)) {
                serviceScope = 2;
            } else if (serviceScopeStr.equalsIgnoreCase(PARAMVALUE_SCOPE_SESSION)) {
                serviceScope = 1;
            }
        }
        VWServiceClass = Class.forName(serviceClassName);
        String serviceMethods = config.getInitParameter(PARAMNAME_METHODS);
        String[] svcs = null;
        if (serviceMethods != null) {
            svcs = this.parseStringList(serviceMethods);
        } else {
            Method[] methods = VWServiceClass.getMethods();
            if (methods != null) {
                int nMethods = methods.length;
                Vector<String> v = new Vector<String>(nMethods);
                while (nMethods-- > 0) {
                    Method m = methods[nMethods];
                    if (!m.getDeclaringClass().equals(VWServiceClass)) continue;
                    v.add(m.getName());
                }
                if (v.isEmpty()) {
                    throw new Exception("No public methods can be found in " + serviceClassName);
                }
                svcs = v.toArray(new String[0]);
            }
        }
        if (svcs == null) {
            throw new Exception("No methods are declared for the " + serviceClassName);
        }
        DeploymentDescriptor vwsvcDD = new DeploymentDescriptor();
        vwsvcDD.setID("urn:filenet-vw-soap-router");
        vwsvcDD.setMethods(svcs);
        vwsvcDD.setScope(serviceScope);
        vwsvcDD.setProviderType((byte)3);
        vwsvcDD.setProviderClass(providerName);
        vwsvcDD.setServiceClass(providerName);
        vwsvcDD.setIsStatic(false);
        logger.exiting(m_className, "getVWSOAPServiceDD", vwsvcDD);
        return vwsvcDD;
    }

    private void getCEURI(ServletContext context) {
        String m_method = "getCEURI";
        try {
            InputStream configStream = context.getResourceAsStream("/WEB-INF/WcmApiConfig.properties");
            this.m_CEURI = Configuration.GetCEURI(configStream, null);
        }
        catch (Exception e) {
            logger.throwing(m_className, "getCEURI", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String m_method = "init";
        try {
            ServletConfig config = this.getServletConfig();
            ServletContext context = config.getServletContext();
            logger.entering(m_className, m_method);
            InputStream inStream = null;
            try {
                P8BPMWSBROKER_PROPERTIES_FILENAME = context.getRealPath("WEB-INF/P8BPMWSBroker.properties");
            }
            catch (Throwable t) {
                logger.throwing(m_className, m_method, t);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, P8BPMWSBROKER_PROPERTIES_FILENAME);
            }
            this.getCEURI(context);
            ServletContext servletContext = context;
            synchronized (servletContext) {
                this.m_soapConfigFileName = config.getInitParameter(PARAMNAME_SOAPCONFIGFILE);
                if (this.m_soapConfigFileName == null) {
                    this.m_soapConfigFileName = PARAMVALUE_SOAPCONFIGFILE_DEFAULT;
                }
                if (this.m_soapConfigFileName != null) {
                    File f = ServerHTTPUtils.getFileFromNameAndContext((String)this.m_soapConfigFileName, (ServletContext)context);
                    this.m_soapConfigFileName = f.getAbsolutePath();
                    if (!f.exists()) {
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "Ignore non-existent file:" + this.m_soapConfigFileName);
                        }
                        this.m_soapConfigFileName = null;
                    } else if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Using file:" + this.m_soapConfigFileName);
                    }
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "SOAPConfigFile is null.");
                }
                new ServiceManager(context, this.m_soapConfigFileName);
                ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)context, (String)this.m_soapConfigFileName);
                serviceManager.deploy(this.getVWSOAPServiceDD());
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Service deployed successfully.");
                }
                logger.info(m_className, m_method, "READY to GO");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.throwing(m_className, m_method, e);
        }
    }

    public void setVWSOAPContext(IVWSOAPContext obj, VWSOAPSessionInfo ses) {
        obj.setContext("PeregrineSession", ses);
        if (this.m_CEURI == null) {
            this.m_CEURI = ses.getCEURI();
        }
        if (this.m_CEURI != null) {
            obj.setContext("CEURI", this.m_CEURI);
        }
        obj.setContext("ConnecionPointsInfo", this.m_CPsInfo);
    }

    private String getVersion(String className) {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("<br>");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("<br>");
                }
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String getObjectInfo(Object o) {
        StringBuffer buf = new StringBuffer();
        buf.append(o.getClass().getName()).append(", classLoader=").append(o.getClass().getClassLoader()).append(", toString=").append(o);
        return buf.toString();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out = res.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        res.setContentType("text/html");
        out.println("<html><head><title>SOAP RPC Router</title></head>");
        out.println("<body><h1>SOAP RPC Router</h1>");
        try {
            this.getCEURI(context);
            String sessionId = req.getRequestedSessionId();
            out.println("FILENET P8 BPM RESPONDED OK");
            out.println("<p>HttpSerletRequest.getRequestedSessionId returns " + sessionId + "</p>");
            out.println("<p>HttpServletRequest.getPathInfo returns " + req.getPathInfo() + "</p>");
            out.println("<p>HttpServletRequest.getContextPath returns " + req.getContextPath() + "</p>");
            Enumeration e1 = context.getAttributeNames();
            out.println("<p><h2>CONTEXT ATTRIBUTES</h2></p><p>");
            while (e1.hasMoreElements()) {
                String s = (String)e1.nextElement();
                Object o = context.getAttribute(s);
                out.println("<br>" + s + "=" + this.getObjectInfo(o));
            }
            HttpSession ses = req.getSession();
            e1 = ses.getAttributeNames();
            out.println("<p><h2>SESSION ATTRIBUTES</h2></p><p>");
            while (e1.hasMoreElements()) {
                String s = (String)e1.nextElement();
                Object o = ses.getAttribute(s);
                out.println("<li>" + s + "=" + this.getObjectInfo(o));
            }
            Cookie[] reqCookies = req.getCookies();
            int nCookies = reqCookies == null ? 0 : reqCookies.length;
            out.println("</p><h2>Number of Cookies=" + Integer.toString(nCookies) + "</h2></p>");
            for (int k = 0; k < nCookies; ++k) {
                out.println("<li>" + reqCookies[k].getName() + "=" + reqCookies[k].getValue() + "</br>");
            }
            try {
                VWSOAPSessionInfo ses2 = VWSOAPSessionInfo.getSessionInfoFromWorkplace(context, req);
                out.println("<p>User=" + ses2.getUser() + "</p>");
                out.println("<p>CP=" + ses2.getFullConnectionPoint() + "</p>");
                out.println("<p>CEURI=" + ses2.getCEURI() + "</p>");
            }
            catch (Throwable e) {
                out.println("<p>There is no logged-on session available, the exception is:</p>");
                e.printStackTrace(out);
            }
            try {
                ClientInfoUtilities.PrintRPCTimingInfoAsHTML(out);
                out.println("-------------------------\n");
                out.println(ClientInfoUtilities.GetClientInfo());
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            out.println("<p>Got exception: " + e.getMessage() + "</p>");
        }
        String version = this.getVersion("filenet.vw.toolkit.utils.VWBuildStamp");
        out.println("<p>PUI Version Info:");
        if (version != null) {
            out.println(version);
        }
        out.println("</p>PUI IDL Version: $Revision:   1.101  $</p>");
        out.println("</p></body></html>");
        out.flush();
        out.close();
    }

    private String getRealCP(String bsCp) {
        try {
            VWBootstrapURL bsURL = new VWBootstrapURL(bsCp);
            URI cpURI = bsURL.getCPURI();
            if (cpURI != null) {
                bsCp = cpURI.toString();
                try {
                    VWRMIRouterURL r = new VWRMIRouterURL(bsCp);
                    bsCp = r.getRouter();
                }
                catch (Throwable t) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bsCp;
    }

    private synchronized void setMyConnectionPointToLocalWSListenerPropertiesFile(String path, String[] cps) {
        int nCps;
        String m_method = "setMyConnectionPointToWSListenerPropertiesFile:" + path;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, Logger.asString(cps));
        }
        int n = nCps = cps == null ? 0 : cps.length;
        if (nCps == 0 || cps[0] == null || cps[0].trim().length() == 0) {
            return;
        }
        String cp = this.getRealCP(cps[0].trim());
        if (this.lastCp != null && this.lastCp.equals(cp)) {
            return;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, cp);
        }
        this.lastCp = cp;
        try {
            WSListenerProperties p = WSListenerProperties.instanceFromFileName(P8BPMWSBROKER_PROPERTIES_FILENAME, null);
            p.setProperty("listener.connectionpoint", this.lastCp);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "listener.connectionpoint=" + this.lastCp);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        VWTimerLog timer = new VWTimerLog("VWRouterServlet.doPost");
        try {
            SOAPContext resCtx;
            int status;
            block29: {
                VWSOAPSessionInfo ses;
                ServletConfig config = this.getServletConfig();
                ServletContext context = config.getServletContext();
                this.getCEURI(context);
                HttpSession session = req.getSession();
                ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)context, (String)this.m_soapConfigFileName);
                Call call = null;
                Response resp = null;
                String targetID = null;
                String fullTargetID = null;
                status = 200;
                DeploymentDescriptor dd = null;
                SOAPContext reqCtx = new SOAPContext();
                resCtx = new SOAPContext();
                Envelope callEnv = null;
                String m_method = "doPost";
                VWRouterServlet.logRequestDetail(req);
                try {
                    ses = null;
                    try {
                        ses = VWSOAPSessionInfo.getSessionInfoFromWorkplace(context, req);
                    }
                    catch (VWNoConnectionPointInSitePref vwe) {
                        String msg = vwe.toString();
                        String s = VWSOAPUtils.base64ObjectSerializer(vwe);
                        SOAPException se = new SOAPException(Constants.FAULT_CODE_SERVER, s, (Throwable)vwe);
                        throw se;
                    }
                    catch (Exception e) {
                        ses = VWSOAPSessionInfo.getSOAPSessionInfoFromToken(context, req);
                    }
                    if (ses != null) {
                        this.setMyConnectionPointToLocalWSListenerPropertiesFile(context.getRealPath("/WEB-INF"), ses.getConnectionPoints());
                    }
                    try {
                        try {
                            DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
                            callEnv = ServerUtils.readEnvelopeFromInputStream((DocumentBuilder)xdb, (InputStream)req.getInputStream(), (int)req.getContentLength(), (String)req.getContentType(), (EnvelopeEditor)this.editor, (SOAPContext)reqCtx);
                        }
                        catch (IllegalArgumentException e) {
                            res.sendError(400, "Error unmarshalling envelope: " + e.getMessage());
                            callEnv = null;
                        }
                        catch (MessagingException me) {
                            res.sendError(400, "Error unmarshalling envelope: " + (Object)((Object)me));
                            callEnv = null;
                        }
                        if (callEnv == null) {
                            return;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        String msg = e.getMessage();
                        String faultCode = msg != null && msg.equals(Constants.ERR_MSG_VERSION_MISMATCH) ? Constants.FAULT_CODE_VERSION_MISMATCH : Constants.FAULT_CODE_CLIENT;
                        throw new SOAPException(faultCode, msg, (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    SOAPException e = null;
                    e = t instanceof SOAPException ? (SOAPException)t : new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception:", "", t);
                    Fault fault = new Fault(e);
                    fault.setFaultActorURI(req.getRequestURI());
                    if (dd != null) {
                        dd.buildFaultRouter(reqCtx).notifyListeners(fault, e);
                    }
                    status = 500;
                    String respEncStyle = null;
                    if (call != null) {
                        respEncStyle = call.getEncodingStyleURI();
                    }
                    if (respEncStyle == null) {
                        respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                    }
                    resCtx = new SOAPContext();
                    resp = new Response(null, null, fault, null, null, respEncStyle, resCtx);
                    SOAPMappingRegistry smr = call != null ? call.getSOAPMappingRegistry() : new SOAPMappingRegistry();
                    Envelope env = resp.buildEnvelope();
                    StringWriter sw = new StringWriter();
                    env.marshall((Writer)sw, (XMLJavaMappingRegistry)smr, resp.getSOAPContext());
                    resp.getSOAPContext().setRootPart(sw.toString(), "text/xml;charset=utf-8");
                    break block29;
                }
                {
                    call = RPCRouter.extractCallFromEnvelope((ServiceManager)serviceManager, (Envelope)callEnv, (SOAPContext)reqCtx);
                    targetID = call.getTargetObjectURI();
                    fullTargetID = call.getFullTargetObjectURI();
                }
                dd = serviceManager.query(targetID);
                RPCJavaProvider provider = null;
                if (dd.getProviderType() == 0) {
                    provider = new RPCJavaProvider();
                } else if (dd.getProviderType() == 3) {
                    Class<?> c = Class.forName(dd.getProviderClass());
                    provider = (Provider)c.newInstance();
                } else {
                    provider = new RPCJavaProvider();
                }
                reqCtx.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                reqCtx.setProperty(Constants.BAG_HTTPSESSION, (Object)session);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETREQUEST, (Object)req);
                reqCtx.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, (Object)res);
                if (provider instanceof IVWSOAPSessionManager) {
                    ((IVWSOAPSessionManager)provider).setSession(ses);
                }
                provider.locate(dd, callEnv, call, call.getMethodName(), fullTargetID, reqCtx);
                provider.invoke(reqCtx, resCtx);
            }
            TransportMessage sres = new TransportMessage(null, resCtx, null);
            sres.editOutgoing(this.editor);
            sres.save();
            res.setStatus(status);
            res.setContentType(sres.getContentType());
            Enumeration headers = sres.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                res.setHeader(name, sres.getHeader(name));
            }
            res.setContentLength(sres.getContentLength());
            ServletOutputStream outStream = res.getOutputStream();
            sres.writeTo((OutputStream)outStream);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!logger.isFinest()) throw new ServletException("Error building response envelope: " + e);
            logger.throwing(m_className, "doPost, generating ServletException", e);
            throw new ServletException("Error building response envelope: " + e);
        }
        finally {
            timer.stop();
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   03 Apr 2009 17:57:14  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.51  $";
    }

    public static void logRequestDetail(HttpServletRequest request) {
        String m_method = "logRequestDetail";
        Logger HTTPlogger = Logger.getLogger("HTTP");
        if (!HTTPlogger.isFinest()) {
            return;
        }
        Cookie[] reqCookies = request.getCookies();
        int nCookies = reqCookies == null ? 0 : reqCookies.length;
        StringBuffer buf = new StringBuffer();
        buf.append("Number of Cookies=").append(nCookies).append("\n");
        for (int k = 0; k < nCookies; ++k) {
            buf.append(reqCookies[k].getName()).append("=").append(reqCookies[k].getValue()).append("\n");
        }
        Enumeration headerNames = request.getHeaderNames();
        buf.append("HEADERS ----\n");
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            buf.append(headerName).append("=").append(request.getHeader(headerName)).append("\n");
        }
        HTTPlogger.finest(m_className, "logRequestDetail", buf.toString());
    }
}

